unit SongClass;

interface

uses sysUtils;

type
  TSong = class
  private
    Artist: String;
    Song: String;
    Album: String;
    TrackNumber: Integer;
    Duration: Integer;
  public
    constructor create; overload;
    constructor create(Artist, Song, Album: String;
      TrackNumber, Duration: Integer); overload;
    function getArtist: String;
    function getSong: String;
    function getAlbum: String;
    function getTrackNumber: Integer;
    function getDuration: Integer;
    procedure setArtist(Artist: String);
    procedure setSong(Song: String);
    procedure setAlbum(Album: String);
    procedure setTrackNumber(TrackNumber: Integer);
    procedure setDuration(Duration: Integer);
    function tostring: String;
    function getQuickReference: String;
    function getMinuteDuration: String;
  end;

implementation

{ TSong }

constructor TSong.create;
begin

end;

constructor TSong.create(Artist, Song, Album: String;
  TrackNumber, Duration: Integer);
begin
  Self.Artist := Artist;
  Self.Song := Song;
  Self.Album := Album;
  Self.TrackNumber := TrackNumber;
  Self.Duration := Duration;
end;

function TSong.getAlbum: String;
begin
  Result := Album;
end;

function TSong.getArtist: String;
begin
  Result := Artist;
end;

function TSong.getDuration: Integer;
begin
  Result := Duration;
end;

function TSong.getMinuteDuration: String;
var
  minutes : Integer;
  seconds : Integer;
begin
  minutes := duration DIV 60;
  seconds := duration MOD 60;
  Result := IntToStr(minutes)+':'+IntToStr(seconds);
end;

function TSong.getQuickReference: String;
begin
  Result := Song + '~' + Album + '~'+ Artist;
end;

function TSong.getSong: String;
begin
  Result := Song;
end;

function TSong.getTrackNumber: Integer;
begin
  Result := TrackNumber;
end;

procedure TSong.setAlbum(Album: String);
begin
  Self.Album := Album;
end;

procedure TSong.setArtist(Artist: String);
begin
  Self.Artist := Artist;
end;

procedure TSong.setDuration(Duration: Integer);
begin
  Self.Duration := Duration;
end;

procedure TSong.setSong(Song: String);
begin
  Self.Song := Song;
end;

procedure TSong.setTrackNumber(TrackNumber: Integer);
begin
  Self.TrackNumber := TrackNumber;
end;

function TSong.tostring: String;
begin
 result := 'Artist: ' + Artist + sLineBreak +
           'Song: ' + Song + sLineBreak +
           'Album: ' + Album + sLineBreak +
           'TrackNumber: ' + IntToStr(TrackNumber) + sLineBreak +
           'Duration: ' + IntToStr(Duration);
end;

end.
